const express = require('express');
const fs = require('fs');
const app = express();
const http = require('http').createServer(app);
const io = require('socket.io')(http);
const session = require('express-session');
const bcrypt = require('bcrypt');

app.use(express.static('public'));
app.use(express.json());

app.use(session({
    secret: 'quizSecretKey2025',
    resave: false,
    saveUninitialized: false
}));

const DATA_FILE = 'teams.json';

// Load teams from JSON file
let teams = JSON.parse(fs.readFileSync(DATA_FILE, 'utf8'));

// Function to save teams to file
function saveTeams() {
    fs.writeFileSync(DATA_FILE, JSON.stringify(teams, null, 2));
}

// Hash admin password
const plainPassword = "quiz2025"; // change to your password
let hashedPassword;
bcrypt.hash(plainPassword, 10, (err, hash) => {
    if(err) throw err;
    hashedPassword = hash;
});

// Middleware to check admin login
function checkAuth(req, res, next) {
    if(req.session && req.session.admin) return next();
    else return res.status(401).json({ success: false, error: "Unauthorized" });
}

// Admin login
app.post('/login', (req, res) => {
    const { password } = req.body;
    bcrypt.compare(password, hashedPassword, (err, result) => {
        if(err) return res.json({ success: false, error: "Error occurred" });
        if(result){
            req.session.admin = true;
            res.json({ success: true });
        } else res.json({ success: false, error: "Invalid password" });
    });
});

// Admin logout
app.post('/logout', (req, res) => {
    req.session.destroy();
    res.json({ success: true });
});

// Update score
app.post('/update', checkAuth, (req, res) => {
    const { teamIndex, increment } = req.body;
    if(teamIndex >= 0 && teamIndex < teams.length){
        teams[teamIndex].score += parseFloat(increment);
        saveTeams(); // Save to JSON file
        io.emit('scoreUpdate', teams);
        res.json({ success: true });
    } else res.json({ success: false });
});

// Rename team
app.post('/rename', checkAuth, (req, res) => {
    const { teamIndex, newName } = req.body;
    if(teamIndex >= 0 && teamIndex < teams.length && newName.trim() !== ''){
        teams[teamIndex].name = newName;
        saveTeams(); // Save to JSON file
        io.emit('scoreUpdate', teams);
        res.json({ success: true });
    } else res.json({ success: false });
});

io.on('connection', socket => {
    socket.emit('scoreUpdate', teams);
});

http.listen(3000, () => console.log('Server running on http://localhost:3000'));
